/*
 * Decompiled with CFR 0.152.
 */
package org.stain.josh.beans.bubbles;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.BreakIterator;
import org.stain.josh.beans.bubbles.GraphPanel;

class Node {
    String nodeName;
    static int nameCounter = 1;
    String bodyText;
    double x = 0.0;
    double y = 0.0;
    double dx = 0.0;
    double dy = 0.0;
    double tension;
    float visibility = 0.0f;
    Color paintColor;
    boolean fixed;
    GraphPanel owningGraph;

    public Node() {
        this.x = 0.0;
        this.y = 0.0;
        this.fixed = false;
        this.bodyText = this.nodeName = "untitled" + Integer.toString(nameCounter);
        ++nameCounter;
    }

    public Node(String name, double posx, double posy) {
        this.x = posx;
        this.y = posy;
        this.fixed = false;
        this.bodyText = this.nodeName = name;
    }

    public Node(String name, String text, double posx, double posy) {
        this.x = posx;
        this.y = posy;
        this.fixed = false;
        this.nodeName = name;
        this.bodyText = text;
    }

    public Node(String name, String text) {
        this.x = 0.0;
        this.y = 0.0;
        this.fixed = false;
        this.nodeName = name;
        this.bodyText = text;
    }

    public void attachToGraph(GraphPanel owner) {
        this.owningGraph = owner;
    }

    public void setText(String theText) {
        this.bodyText = theText;
    }

    public void paint(Graphics g, FontMetrics fm) {
        int ix = (int)this.x;
        int iy = (int)this.y;
        g.setColor(Color.black);
        g.fillOval(ix - 5, iy - 5, 10, 10);
    }

    public void paintText(Graphics g, FontMetrics fm) {
        if ((double)this.visibility > 0.0) {
            int ix = (int)this.x;
            int iy = (int)this.y;
            g.setColor(new Color(1.0f - this.visibility, 1.0f - this.visibility, 1.0f - this.visibility));
            int lineHeight = fm.getHeight() / 2;
            int linePos = iy;
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(this.bodyText);
            int start = boundary.first();
            int totalLength = this.bodyText.length();
            int end = start + 40 <= totalLength ? boundary.following(start + 40) : totalLength;
            while (start < totalLength) {
                String aLine = this.bodyText.substring(start, end);
                float w = (float)fm.stringWidth(aLine) * (5.0f - 4.0f * this.visibility) + 10.0f;
                float step = w / (float)aLine.length();
                float pos = (float)ix - (w - 10.0f) / 2.0f;
                char[] letters = aLine.toCharArray();
                int a = 0;
                while (a < aLine.length()) {
                    g.drawChars(letters, a, 1, (int)pos, linePos);
                    pos += step;
                    ++a;
                }
                int nextStart = end;
                end = start + 40 < totalLength ? boundary.following(start + 40) : totalLength;
                start = nextStart;
                linePos += lineHeight;
            }
            this.visibility = (float)((double)this.visibility - 0.1);
        }
    }
}

