/*
 * Decompiled with CFR 0.152.
 */
package org.stain.josh.beans.bubbles;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import org.stain.josh.beans.bubbles.Node;

public class ImageNode
extends Node {
    Image nodeImage = null;
    int imageHeight = 1;
    int imageWidth = 1;

    public ImageNode(String filename, int ix, int iy) {
        super(filename, ix, iy);
        this.nodeName = filename;
    }

    public ImageNode(String filename, String text, int ix, int iy) {
        super(filename, ix, iy);
        this.nodeName = filename;
        this.bodyText = text;
    }

    public ImageNode(String filename) {
        this.nodeName = filename;
    }

    public void paint(Graphics g, FontMetrics fm) {
        if (this.nodeImage == null) {
            this.MakeImage(this.nodeName);
        }
        if ((double)this.visibility > 0.0) {
            int ix = (int)this.x - this.imageWidth / 2;
            int iy = (int)this.y - (this.imageHeight + 10);
            g.setColor(this.paintColor);
            g.drawImage(this.nodeImage, ix, iy, null);
            this.paintText(g, fm);
        } else {
            int ix = (int)this.x - this.imageWidth / 2;
            int iy = (int)this.y - this.imageHeight / 2;
            g.setColor(this.paintColor);
            g.drawImage(this.nodeImage, ix, iy, null);
        }
    }

    private void MakeImage(String imageURL) {
        MediaTracker tracker = new MediaTracker(this.owningGraph);
        this.nodeName = imageURL;
        this.nodeImage = Toolkit.getDefaultToolkit().getImage(imageURL);
        tracker.addImage(this.nodeImage, 1);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Couldn't load image:" + this.nodeName);
        }
        this.imageWidth = this.nodeImage.getWidth(null);
        this.imageHeight = this.nodeImage.getHeight(null);
    }

    private void translucentBlit(Graphics g) {
    }
}

