/*
 * Decompiled with CFR 0.152.
 */
package org.stain.josh.beans.bubbles;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import org.stain.josh.beans.bubbles.CircleNode;
import org.stain.josh.beans.bubbles.Edge;
import org.stain.josh.beans.bubbles.Node;

public class GraphPanel
extends Canvas
implements Runnable,
Serializable {
    int nnodes;
    Node[] nodes = new Node[100];
    int nedges;
    Edge[] edges = new Edge[200];
    Thread relaxer;
    boolean stress;
    boolean random;
    int mouseX;
    int mouseY;
    Node pick;
    boolean pickfixed;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;

    public int findNode(String nodeName) {
        int i = 0;
        while (i < this.nnodes) {
            if (this.nodes[i].nodeName.equals(nodeName)) {
                return i;
            }
            ++i;
        }
        return this.addNode(nodeName);
    }

    public int addNode(Node newNode) {
        this.nodes[this.nnodes] = newNode;
        newNode.attachToGraph(this);
        return this.nnodes++;
    }

    public int addNode(String nodeName) {
        double nodex = 10.0 + 380.0 * Math.random();
        double nodey = 10.0 + 380.0 * Math.random();
        CircleNode n = new CircleNode(nodeName, (int)nodex, (int)nodey);
        return this.addNode(n);
    }

    public void addEdge(String from, String to, int len) {
        this.addEdge(this.nodes[this.findNode(from)], this.nodes[this.findNode(to)], len);
    }

    public void addEdge(Node from, Node to, int len) {
        Edge e = new Edge();
        e.from = from;
        e.to = to;
        e.len = len;
        this.edges[this.nedges++] = e;
    }

    public void run() {
        while (true) {
            this.singleStep();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void singleStep() {
        this.relax();
    }

    synchronized void relax() {
        double dy;
        double dx;
        double len;
        double vy;
        double vx;
        int i = 0;
        while (i < this.nedges) {
            Edge e = this.edges[i];
            vx = e.to.x - e.from.x;
            vy = e.to.y - e.from.y;
            len = Math.sqrt(vx * vx + vy * vy);
            double mag = (e.to.x - (double)this.mouseX) * (e.to.x - (double)this.mouseX) + (e.to.y - (double)this.mouseY) * (e.to.y - (double)this.mouseY);
            mag += (e.from.x - (double)this.mouseX) * (e.from.x - (double)this.mouseX) + (e.from.y - (double)this.mouseY) * (e.from.y - (double)this.mouseY);
            mag = 10000.0 / mag + 0.3;
            e.mag = mag = (mag - e.mag) / 4.0 + e.mag;
            double f = (this.edges[i].len * mag - len) / (len * 3.0);
            dx = f * vx;
            dy = f * vy;
            e.to.dx += dx;
            e.to.dy += dy;
            e.from.dx += -dx;
            e.from.dy += -dy;
            ++i;
        }
        Node closest = null;
        double closestDistance = 999999.0;
        int i2 = 0;
        while (i2 < this.nnodes) {
            Node n1 = this.nodes[i2];
            n1.tension = 0.0;
            dx = 0.0;
            dy = 0.0;
            int j = 0;
            while (j < this.nnodes) {
                if (i2 != j) {
                    Node n2 = this.nodes[j];
                    vx = n1.x - n2.x;
                    vy = n1.y - n2.y;
                    len = vx * vx + vy * vy;
                    if (len == 0.0) {
                        dx += Math.random();
                        dy += Math.random();
                    } else if (len < 10000.0) {
                        dx += vx / len;
                        dy += vy / len;
                    }
                }
                ++j;
            }
            double dlen = dx * dx + dy * dy;
            if (dlen > 0.0) {
                dlen = Math.sqrt(dlen) / 2.0;
                n1.dx += dx / dlen;
                n1.dy += dy / dlen;
                n1.tension += dlen;
            }
            if ((dlen = (n1.x - (double)this.mouseX) * (n1.x - (double)this.mouseX) + (n1.y - (double)this.mouseY) * (n1.y - (double)this.mouseY)) < closestDistance) {
                closestDistance = dlen;
                closest = n1;
            }
            ++i2;
        }
        if (closestDistance < 200.0) {
            vx = closest.x - (double)this.mouseX;
            vy = closest.y - (double)this.mouseY;
            len = (200.0 - Math.sqrt(vx * vx + vy * vy)) / 200.0;
            closest.dx -= vx * len;
            closest.dy -= vy * len;
            if ((double)closest.visibility < 1.0) {
                closest.visibility += 0.3f;
            }
            if ((double)closest.visibility > 1.0) {
                closest.visibility = 1.0f;
            }
        }
        Dimension d = this.size();
        int i3 = 0;
        while (i3 < this.nnodes) {
            Node n = this.nodes[i3];
            if (!n.fixed) {
                n.x += Math.max(-5.0, Math.min(5.0, n.dx));
                n.y += Math.max(-5.0, Math.min(5.0, n.dy));
                if (n.x < 0.0) {
                    n.x = 0.0;
                } else if (n.x > (double)d.width) {
                    n.x = d.width;
                }
                if (n.y < 0.0) {
                    n.y = 0.0;
                } else if (n.y > (double)d.height) {
                    n.y = d.height;
                }
            }
            n.dx /= 2.0;
            n.dy /= 2.0;
            ++i3;
        }
        this.repaint();
    }

    public synchronized void update(Graphics g) {
        Dimension d = this.size();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            Font myFont = new Font("Courier", 0, 12);
            this.offgraphics.setFont(myFont);
        }
        this.offgraphics.setColor(Color.white);
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        int i = 0;
        while (i < this.nedges) {
            Edge e = this.edges[i];
            e.paint(this.offgraphics);
            ++i;
        }
        FontMetrics fm = this.offgraphics.getFontMetrics();
        int i2 = 0;
        while (i2 < this.nnodes) {
            this.nodes[i2].paint(this.offgraphics, fm);
            ++i2;
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public synchronized boolean mouseMove(Event evt, int x, int y) {
        this.mouseX = x;
        this.mouseY = y;
        return true;
    }

    public synchronized boolean mouseDown(Event evt, int x, int y) {
        double bestdist = Double.MAX_VALUE;
        int i = 0;
        while (i < this.nnodes) {
            Node n = this.nodes[i];
            double dist = (n.x - (double)x) * (n.x - (double)x) + (n.y - (double)y) * (n.y - (double)y);
            if (dist < bestdist) {
                this.pick = n;
                bestdist = dist;
            }
            ++i;
        }
        this.pickfixed = this.pick.fixed;
        this.pick.fixed = true;
        this.pick.x = x;
        this.pick.y = y;
        this.repaint();
        return true;
    }

    public synchronized boolean mouseDrag(Event evt, int x, int y) {
        this.pick.x = x;
        this.pick.y = y;
        this.repaint();
        return true;
    }

    public synchronized boolean mouseUp(Event evt, int x, int y) {
        this.pick.x = x;
        this.pick.y = y;
        this.pick.fixed = this.pickfixed;
        this.pick = null;
        this.edges = new Edge[200];
        int nedges = (int)(Math.random() * (double)this.nnodes * 4.0) + this.nnodes;
        int i = 0;
        while (i < this.nnodes * 3) {
            Edge e = new Edge();
            e.len = Math.random() * 300.0 + 10.0;
            Node fromNode = null;
            Node toNode = null;
            while (fromNode == toNode) {
                fromNode = this.nodes[(int)(Math.random() * (double)(this.nnodes - 1)) + 1];
                toNode = this.nodes[(int)(Math.random() * (double)(this.nnodes - 1)) + 1];
            }
            e.from = fromNode;
            e.to = toNode;
            this.edges[i] = e;
            ++i;
        }
        this.repaint();
        return true;
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    public void stop() {
        this.relaxer.stop();
    }
}

